@extends('admin.layout.page-app')
@section('page_title', __('label.1_vs_1_battles'))
@section('tab_title', __('label.1_vs_1_battles'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.1_vs_1_battles')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.one_vs_one_battles.index') }}">{{__('label.1_vs_1_battles')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.1_vs_1_battles_details')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.one_vs_one_battles.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.1_vs_1_battles')}}</a>
				</div>
			</div>

            <div class="row">
                <div class="col-4">
                    <div class="card custom-border-card mt-3 bg-card-gradient">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ $data['c_user']['image'] ?? asset('assets/imgs/default.png') }}" class="profile-picture rounded-circle mt-0" width="60" height="60">
                            <div class="ml-4 text-left">
                                <h4>{{ $data['c_user']['full_name'] ?? '' }}</h4>
                                <h5>{{__('label.attended')}} : {{ $data['c_questions_attended'] ?? 0 }}</h5>
                                <h5>{{__('label.correct')}} : {{ $data['c_correct_answers'] ?? 0 }}</h5>
                                <h5>{{__('label.percentage')}} : {{ $data['c_percentage'] ?? 0 }}%</h5>
                            </div>
                        </div>

                        @if ($data['w_user_id'] == $data['c_user']['id'])
                            <span class="badge green-bg mt-2">{{ __('label.winner') }}</span>
                        @elseif ($data['l_user_id'] == $data['c_user']['id'])
                            <span class="badge red-bg mt-2">{{ __('label.loser') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-4">
                    <div class="card custom-border-card mt-3 align-items-center p-3">
                        <span class="badge primary-bg mb-2">Room Code : {{ $data['room_code'] }}</span>
                        <h6 class="mb-2">{{ $data['name'] }}</h6>
                        <h1 class="fw-bold primary-color">VS</h1>
                        <div class="d-flex justify-content-between w-100 px-4 py-2 h6">
                            <span>{{__('label.joining_coin')}} : {{ $data['joining_coin'] }}</span>
                            <span>{{__('label.winning_coin')}} : {{ $data['winning_coin'] }}</span>
                        </div>
                        <p>{{__('label.total_questions')}} : {{ $data['total_questions'] }}</p>
                    </div>
                </div>
                <div class="col-4">
                    <div class="card custom-border-card mt-3 bg-card-gradient">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ $data['j_user']['image'] ?? asset('assets/imgs/default.png') }}" class="profile-picture rounded-circle mt-0" width="60" height="60">
                            <div class="ml-4 text-left">
                                <h4>{{ $data['j_user']['full_name'] ?? '' }}</h4>
                                <h5>{{__('label.attended')}} : {{ $data['j_questions_attended'] ?? 0 }}</h5>
                                <h5>{{__('label.correct')}} : {{ $data['j_correct_answers'] ?? 0 }}</h5>
                                <h5>{{__('label.percentage')}} : {{ $data['j_percentage'] ?? 0 }}%</h5>
                            </div>
                        </div>

                       @if (isset($data['j_user']['id']) && $data['w_user_id'] == $data['j_user']['id'])
                            <span class="badge green-bg mt-2">{{ __('label.winner') }}</span>
                        @elseif (isset($data['j_user']['id']) && $data['l_user_id'] == $data['j_user']['id'])
                            <span class="badge red-bg mt-2">{{ __('label.loser') }}</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
